using System;
using System.Windows.Forms;
using System.Drawing;
//
// Przecigaj kursor myszy, aby rysowa w odpowiednim polu.
// Prawy przycisk rysuje czerwon lini. Lewy przycisk rysuje czarn lini.
//
class MyWinApp
{
   static void Main() 
   {
   	   Form mainForm = new DrawingForm();
   	   Application.Run(mainForm);  
   }
}
// Formularz uytkownika potomny wzgldem klasy bazowej Form.
class DrawingForm:Form
{
   Point lastPoint = Point.Empty; // Zapisuje wsprzdne.
   public Pen myPen;		// Definiuje kolor odcinka.
   public DrawingForm() 
   {
	   this.Text = "Blok rysunkowy";
	   // Tworzy delegacje wywoujce metody OnMouseUp i OnMouseDown w odpowiedzi na zdarzenia.
  	   this.MouseDown += new MouseEventHandler(OnMouseDown);
	   this.MouseUp   += new MouseEventHandler(OnMouseUp);
   }
     
   private void OnMouseDown(object sender, MouseEventArgs e)
   {         
       myPen = (e.Button==MouseButtons.Right)? Pens.Red: Pens.Black;
       lastPoint.X = e.X;
       lastPoint.Y = e.Y;
   }
   
   private void OnMouseUp(object sender, MouseEventArgs e)
   {
       Graphics g = this.CreateGraphics(); // Tworzy obiekt klasy Graphics.
       if (lastPoint != Point.Empty) 
   	      g.DrawLine(myPen, lastPoint.X,lastPoint.Y,e.X,e.Y);
       lastPoint.X = e.X;
       lastPoint.Y = e.Y;
	   g.Dispose();
   }	
}