using System;
using System.IO;
using System.Security.Cryptography;
// Przykad uycia strumienia szyfrowania CryptoStream.
public class MyApp
{		 
    static void Main() 	 
    {
		 // Otwiera plik, w ktrym zostanie zapisany zaszyfrowany acuch.
		 string toEncrypt= "Wybrane miejsce ley we Woszech.";
		FileStream fs=null;
		try
		{
		 fs = new FileStream(@"\testcrypt.txt", FileMode.Create, 
		 FileAccess.Write);	
		 MyApp.WriteEncrypt(fs, toEncrypt);
		 fs= new FileStream(@"\testcrypt.txt",FileMode.Open, 
			   FileAccess.Read);
		 string msg = MyApp.ReadEncrypt(fs);
		 Console.WriteLine(msg);	
                                 } catch (Exception ex)
                                 {Console.WriteLine(ex.Message);}
		 fs.Close(); 
                                 Console.Read();
    } 
   
	// Szyfruje strumie.
	private static void WriteEncrypt(FileStream fs, string msg) 
	{
		// (1) Tworzy obiekt standardu DES (Create Data Encryption Standard).
		DESCryptoServiceProvider crypt = new DESCryptoServiceProvider();
		// (2) Tworzy klucz i wektor inicjalizacji - wymaga 8 bajtw.
		crypt.Key = new byte[] {71,72,83,84,85,96,97,78};
		crypt.IV  = new byte[] {71,72,83,84,85,96,97,78};
		// (3) Tworzy obiekt strumienia typu CryptoStream.
		CryptoStream cs = new CryptoStream(fs,
		   crypt.CreateEncryptor(),CryptoStreamMode.Write);
		// (4) Tworzy obiekt klasy StreamWriter na bazie istniejcego obiektu klasy CryptoStream.
		StreamWriter sw = new StreamWriter(cs);
		sw.Write(msg);
		sw.Close();
		cs.Close();
	}
	
	// Odczytuje i deszyfruje strumie plikowy.
	private static string ReadEncrypt(FileStream fs) 
	{
		// (1) Tworzy obiekt standardu DES (Create Data Encryption Standard).
		DESCryptoServiceProvider crypt = new DESCryptoServiceProvider();
		// (2) Tworzy klucz i wektor inicjalizacji - wymaga 8 bajtw.
		crypt.Key = new byte[] {71,72,83,84,85,96,97,78};
		crypt.IV  = new byte[] {71,72,83,84,85,96,97,78};
		// (3) Tworzy obiekt strumienia typu CryptoStream.
		CryptoStream cs = new CryptoStream(fs,
			 crypt.CreateDecryptor(),CryptoStreamMode.Read);
		// (4) Tworzy obiekt klasy StreamReader na bazie istniejcego obiektu klasy CryptoStream.
		StreamReader sr = new StreamReader(cs);
		string msg = sr.ReadToEnd();
		sr.Close();
		cs.Close();
		return msg;
	}   
}