using System;

	public interface IApparel    // Interfejs reprezentujcy produkt.
	{
	    string ShowMe();
	    bool Knit        // Waciwo okrelajca, czy produkt jest uszyty z dzianiny.
	    { get; }    
	}
	public class SportsShirt : IApparel
	{
	    public string ShowMe() 
	    {
		  return("Koszulka sportowa");
	    }
	    public bool Knit 
	    { get {return true;} }
	}
	public class DressShirt : IApparel
	{
	    public string ShowMe() 
	    {
		  return("Koszula galowa");
	    }
	    public bool Knit 
	    { get {return false;} }
	}
	// Klasa fabrykujca, ktrej jedyna metoda zwraca obiekty klas implementujcych interfejs IApparel.
    	public class ApparelFactory
	{
	    public IApparel CreateApparel( string apptype)
	    {
		  switch (apptype) 
		  {
			case "MDRSHIRT":
				return new DressShirt();
			case "MSPSHIRT":
				return new SportsShirt();
		  }
		  return null;
	    }	
	} 

	public class MyApp
	{  
    	public static void Main()
    	{ 
       		ApparelFactory factory= new ApparelFactory();     
     		IApparel ob1 = factory.CreateApparel("MDRSHIRT");
     		IApparel ob2 = factory.CreateApparel("MSPSHIRT");
     	  	Console.WriteLine(ob1.ShowMe()); // Zwraca acuch "Koszula galowa".
       		Console.Read();     	  	
    	}
}
