using System;
// Niestandardowa klasa wyjtku
[Serializable]
public class NoDescException : ApplicationException
{   // Naley zaimplementowa a trzy konstruktory.
    public NoDescException(){}
    public NoDescException(string message):base(message){}
    public NoDescException(string message, Exception innerEx):base(message, innerEx){ }
}
    
// Interfejsy implementowane przez obiekty reprezentujce ksztaty
public interface IShapeFunction
    { double GetArea(); }
public interface IShapeDescription
    { string ShowMe(); }

// Zdefiniowano klasy Circle i Rectangle.
class Circle : IShapeFunction
{
    private double radius;
    public Circle (double rad)
    {
        radius = rad;
    }
    // Metoda wymagana od klas implementujcych interfejs
    public double GetArea()
    {  return (3.14*radius*radius);  }
}
class Rectangle : IShapeFunction , IShapeDescription 
{
    private int width, height;
    public Rectangle(int w, int h)
    {
        width  = w;
        height = h;
    }
    // Metody wymagane od klas implementujcych oba interfejsy
    public double GetArea()
    {  return (height*width);  }
    public string ShowMe()
    {  return("prostokt");    }
}
    
public class ObjAreas
{
    public static void ShowAreas(object ObjShape)
    {    
        // Sprawdza, czy obiekt ObjShape implementuje oba interfejsy.
        if (!(ObjShape is IShapeDescription && ObjShape is IShapeFunction) )
        {  
            // Generuje niestandardowy wyjtek. 
            string objName = ObjShape.ToString();
            throw new NoDescException("Obiekt " + objName +
                                      " nie implementuje wymaganych interfejsw.");
        }  
        // Jeli obiekt ObjShape implementuje oba interfejsy, kontynuuje przetwarzanie.
        IShapeFunction myShape   = (IShapeFunction)ObjShape;
        IShapeDescription myDesc = (IShapeDescription) ObjShape;
        string desc = myDesc.ShowMe();
        Console.WriteLine(desc + " Pole powierzchni = " +
                          myShape.GetArea().ToString());
    }
} 


class MyApp 
{
	public static void Main() 
	{ 
		 Circle myCircle = new Circle(4.0);
		 Rectangle myRect = new Rectangle(5,2);
		 try 
		 {
			 ObjAreas.ShowAreas(myRect);
			 ObjAreas.ShowAreas(myCircle);
		 }
		 catch (NoDescException ex) 
		 {
			 Console.WriteLine(ex.Message);
		 }	
                 Console.Read();
	}
}	