using System;
using System.Windows.Forms;
using System.Drawing;
using System.IO;
using System.Web.Services;
using System.Net;
// This program is a WinForms version of imgclient.cs
// compile: csc /t:winexe /r:imgproxy.dll winimageclient.cs
class MyWinApp
{
	static void Main() 
	{
		// (1) Tworzy formularz i wywouje go
		Form mainForm = new SimpleForm();
		Application.Run(mainForm);  
	}
}
// Formularz uytkownika dziedziczony po klasie Form
class SimpleForm:Form
{
	private Button button1;
	private ListBox imageList;
	private PictureBox pb;
	private Label label1;
	public SimpleForm() 
	{		 
		try
		{
			BuildControlTree();
			button1.Click += new EventHandler(button1_Click);	
			//imageList.Items.Add("Stanwyck0");
			WSImages myImage = new WSImages();
			// Wywouje ListIMages aby pobra list obrazw na serwerze
			string[]imgList= myImage.ListImages();
			for(int i=0; i<imgList.Length;i++)
			{
				string imgParse= Path.GetFileName(imgList[i]);
				imgParse= imgParse.Substring(0,imgParse.IndexOf("."));
				imageList.Items.Add(imgParse);
			}
		} catch (Exception ex) {MessageBox.Show(ex.Message);}
	}
	private void BuildControlTree()
	{
		this.Text = "Dostp do usugi sieciowej WSImages";
		this.Width= 360;
		this.Height= 250;
		// (1) Create a button control and set some attributes
		button1 = new Button();
		button1.Location = new Point(16,182);
		button1.Size = new Size(72,24);
		button1.Text= "Wybierz";
		this.Controls.Add(button1);  	  		
		// (2) PictureBox to hold downloaded Image
		pb = new PictureBox();
		pb.Location= new Point(120,20);
		pb.Size = new Size(200,180);
		pb.BackColor= Color.White;
		//pb.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
		this.Controls.Add(pb);
		// (3) ListBox to hold list of images
		imageList = new ListBox();
		imageList.Location = new Point(8,20);
		imageList.Size= new Size(100,160);
		imageList.BorderStyle = BorderStyle.Fixed3D;		
		this.Controls.Add(imageList);	 
		// (4) Label
		label1 = new Label();
		label1.Location = new Point(8,2);
		label1.Size = new Size(60,16);
		label1.Text="Obrazy";
		this.Controls.Add(label1);
	}
	// Try to retrieve image from web service
	void button1_Click(object sender, EventArgs e) 
	{
		string selPicture= (string)imageList.SelectedItem;
		if(selPicture !=null)
		{
			try
			{
				WSImages myImage = new WSImages();
				byte[] image = myImage.GetImage(selPicture);    // call web service method
				MemoryStream memStream = new MemoryStream(image); 
				//Console.WriteLine("Size of returned image in bytes: {0}",memStream.Length);
				Bitmap bm = new Bitmap(memStream); 
				ScaleToFit(bm);    // Place image in imagebox				
			}
			catch (WebException ex)
			{
				MessageBox.Show(ex.Message);
				
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.Message);				
			}		
		}
	}  
	// This method scales an image to fit into the PictureBox
	private void ScaleToFit(Bitmap newBmp)
	{
		decimal panelRatio = (decimal)pb.Width/(decimal)pb.Height;
		decimal bmpRatio = (decimal)newBmp.Width/(decimal)newBmp.Height;
		int w= pb.Width;
		int h= pb.Height;
		if(panelRatio==bmpRatio)  // panel and image have same h/w ratio
		{
			w=pb.Width;
			h=pb.Height;
		}
		else
		{
			if (panelRatio> bmpRatio)
			{
				h= (int) pb.Height;
				w= (int) (((decimal)h/(decimal)newBmp.Height)*(decimal)newBmp.Width );
			}
			else
			{
				w= (int) pb.Width;
				h= (int) (((decimal)w/ (decimal)newBmp.Width)*(decimal)newBmp.Height);
			}
		}
		Rectangle dRect= new Rectangle(new Point(0,0),new Size(w, h));
		Bitmap bmpMem = new Bitmap(w,h);
		Graphics gmem= Graphics.FromImage(bmpMem);
		gmem.DrawImage(newBmp,dRect);
		pb.Image= bmpMem;
		gmem.Dispose(); 
	}
}