using System;
using System.Runtime.Remoting;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Http;
using System.Collections;
using System.Reflection;
using SimpleServer;   // Przestrze nazw serwera
// Kompilacja: csc /r:msgserver.dll msgclient.cs
[assembly: AssemblyVersion("1.0.0.0"), System.CLSCompliant(true)]
namespace SimpleClient
{
   public class MessageClient
   {
      static void Main(string[] args)
      {
         string myID;
         // Identyfikator klienta przekazywany jest jako argument wiersza polece
         if (args.Length > 0) myID = args[0]; else myID = "001";
         Console.WriteLine("Klient zosta uruchomiony.");
         // (1) Rejestruje kana
         HttpChannel c = new HttpChannel();
         ChannelServices.RegisterChannel(c);
         // (2) Rejestruje typ  obiekt aktywowany przez serwer przez port 3200
         Type ServerType = typeof(SimpleServer.MessageManager);
         string url = "http://localhost:3200/MojObiekt";
         // Rejestruje typ w trybie aktywacji przez serwer
         RemotingConfiguration.RegisterWellKnownClientType(
            ServerType, url);
         // (3) Tworzy instancj zdalnego obiektu
         MessageManager mm = new MessageManager();
         string msg; 
         string oper = "";
         // Pozwala uytkownikom wysya i odbiera wiadomoci
         while (oper != "Z")
         {
            Console.WriteLine("(W)ylij, (O)dbierz, (Z)akocz");
            oper = Console.ReadLine();
            oper = oper.ToUpper();
            if (oper == "W"){
               Console.WriteLine("Wpisz identyfikator odbiorcy: wiadomo");
               msg = Console.ReadLine();
               // Dwukropek (:) oddziela identyfikator od wiadomoci
               int ndx = msg.IndexOf(":");
               if (ndx > 0) {
                  string recipientID = msg.Substring(0, ndx).Trim();
                  msg = msg.Substring(ndx+1);
                  mm.SetMessage(msg, myID, recipientID);
               }
            } else
            {
               if (oper == "O") {
                  Console.WriteLine(mm.FetchMessages(myID));
               }
            }
         } // while
      } // metoda
   } // class
} // namespace
