#define VERSION2
using System;
using System.Xml;
using System.IO;
using System.Text;
// Zapisuje dokument XML za pomoc klasy XmlTextWriter (1.0) lub XmlWriter (2.0)
public class Writer
{
	public static void Main()
	{           
		WriteMovie();
		Console.Read();
	}
	// .NET Framework 1.1
	#if(VERSION1)
	private static void WriteMovie()
	{
		string[,] movieList = { { "Annie Hall", "Woody Allen" },
							  { "Lawrence z Arabii", "David Lean" } };
		// (2) Tworzy obiekt klasy XmlTextWriter, ktry moe wskazywa albo na plik, albo na konsol.
		XmlTextWriter writer = new XmlTextWriter(Console.Out);        
		writer.WriteStartDocument();
		writer.WriteComment("Dane wynikowe zwrcone przez obiekt klasy XmlTextWriter");
		writer.WriteStartElement("films");
		for (int i = 0; i <= movieList.GetUpperBound(0) ; i++)
		{
			try
			{
				writer.WriteStartElement("movie");
				writer.WriteElementString("Title", movieList[i, 0]);
				writer.WriteElementString("Director", movieList[i, 1]);
				writer.WriteElementString("Movie_ID",i.ToString());
				writer.WriteEndElement();
			}
				catch (Exception ex)
			{
				Console.WriteLine(ex.Message);
			}                 
		}
		writer.WriteEndElement();
		writer.Flush();    // Zapisuje ca pozosta zawarto w strumieniu XML.
		writer.Close();			
	}
	#endif
	 
	#if (VERSION2)
	// .NET Framework 2.0
	private static void WriteMovie()
	{
		string[,] movieList = { { "Annie Hall", "Woody Allen" },
							  { "Lawrence z Arabii", "David Lean" } };
		// (1) Definiuje ustawienia okrelajce sposb zapisywania danych.
		XmlWriterSettings settings = new XmlWriterSettings();
		settings.Indent = true;
		settings.IndentChars = ("    ");
		settings.ConformanceLevel = ConformanceLevel.Document;
		settings.CloseOutput = false;
		settings.OmitXmlDeclaration = false;
		// (2) Tworzy obiekt klasy XmlWriter, ktry zostanie uyty do zapisania danych w pliku.
		string outFile= @"c:\moje filmy.xml";
		XmlWriter writer = XmlWriter.Create(outFile, settings);        
		writer.WriteStartDocument();
		writer.WriteComment("Dane wynikowe zwrcone przez obiekt klasy XmlWriter");
		writer.WriteStartElement("films");
		for (int i = 0; i <= movieList.GetUpperBound(0) ; i++)
		{
			try
			{
				writer.WriteStartElement("movie");
				writer.WriteElementString("Title", movieList[i, 0]);
				writer.WriteElementString("Director", movieList[i, 1]);
				writer.WriteStartElement("Movie_ID");
				writer.WriteValue(i); // Nie musimy konwertowa do typu acuchowego.
				writer.WriteEndElement();
				writer.WriteEndElement();
			}
			catch (Exception ex)
			{
				Console.WriteLine(ex.Message);
			}                 			
		}
		writer.WriteEndElement();
		writer.Flush();    // Zapisuje ca pozosta zawarto w strumieniu XML.
		writer.Close();   	
		Console.WriteLine("Kod XML zapisany w pliku: {0}",outFile);
	}    
	#endif

	/*
			Output:
				<?xml version="1.0" encoding="utf-8"?>
				<!--Output from xmlwriter class-->
				<films>
					<movie>
						<Title>Annie Hall</Title>
						<Director>Woody Allen</Director>
						<Movie_ID>0</Movie_ID>
					</movie>
					<movie>
						<Title>Lawrence z Arabii</Title>
						<Director>David Lean</Director>
						<Movie_ID>1</Movie_ID>
					</movie>
				</films>	 	 	 
	*/
}  