#define VERSION1
using System;
using System.Xml;
using System.Xml.XPath;
using System.IO;
using System.Xml.Xsl;
using System.Text;
// Odczytuje wzy z pliku XML. Zastosowano kompilacj warunkow dla wersji platformy .NET 1.x oraz .NET 2.0.
public class Transform
{
	public static void Main()
	{           
		ListMovies();
		Console.Read();
	}
	// .NET Framework 1.1
	#if (VERSION1)
	
	private static void ListMovies()
	{
		XmlDocument doc = new XmlDocument();
		doc.Load(new StreamReader("c:\\filmy oskarowe.xml", Encoding.GetEncoding(1250)));
		XmlNodeReader noderdr = new XmlNodeReader(doc);
		while (noderdr.Read())
		{
			if(noderdr.NodeType==XmlNodeType.Element)
			{
				if (noderdr.Name == "movie_Title")
				{
					noderdr.Read();  // Nastpny wze zawiera waciwy acuch tytuu.
					Console.Write(noderdr.Value + " ");    /// Tytu filmu
				}
				if (noderdr.Name == "movie_Year")
				{
					noderdr.Read();  // Nastpny wze zawiera waciwy acuch roku.
					Console.WriteLine(noderdr.Value); 	// Rok premiery filmu                            
				}
			}	 	

		}  // while
	}  // ListMovies
	
	#endif

	#if (VERSION2)
	
	// .NET Framework 2.0 version	
	private static void ListMovies()
	{
		// (1) Okrela, ktry plik XML ma zosta wczytany w formie struktury DOM.
		XmlDocument doc = new XmlDocument();
		doc.Load(new StreamReader("c:\\filmy oskarowe.xml", Encoding.GetEncoding(1250)));
		// (2) Ustawienia wykorzystywane podczas pracy obiektu klasy XmlNodeReader.
		XmlReaderSettings settings = new XmlReaderSettings();
		settings.ConformanceLevel = ConformanceLevel.Auto;
		settings.IgnoreWhitespace = true;
		settings.IgnoreComments = true;
		/// (3) Tworzy obiekt klasy XmlNodeReader.
		XmlNodeReader noderdr = new XmlNodeReader(doc);
		// (4) Tworzy obiekt klasy XmlReader, ktry bdzie peni funkcj opakowania dla obiektu klasy XmlNodeReader.
		XmlReader reader = XmlReader.Create(noderdr, settings);            
		Console.WriteLine("Tytuy filmw odczytane z pliku XML\r\n\r\n");
		while (reader.Read())
		{
			if(reader.NodeType==XmlNodeType.Element)
			{
				if (reader.Name == "movie_Title")
				{
					reader.Read();  // Nastpny wze zawiera waciwy acuch tytuu.
					Console.Write(reader.Value + " ");    // Tytu filmu
				}
				if (reader.Name == "movie_Year")
				{
					reader.Read();  // Nastpny wze zawiera waciwy acuch roku.
					Console.WriteLine(reader.Value);    // Rok premiery filmu

				}
			}
		}
	} 
	
	#endif
}  