using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Drawing.Drawing2D;

namespace gdicolors
{
    /// <summary>
    /// Summary description for Form1.
    /// </summary>
    public class Form1 : System.Windows.Forms.Form
    {
        private System.Windows.Forms.Panel panel1;
        private System.Windows.Forms.TextBox rText;
        private System.Windows.Forms.TextBox gText;
        private System.Windows.Forms.TextBox bText;
        private System.Windows.Forms.TextBox hText;
        private System.Windows.Forms.TextBox sText;
        private System.Windows.Forms.TextBox lText;
        private System.Windows.Forms.Label label1;
        private System.Windows.Forms.Label label2;
        private System.Windows.Forms.Label label3;
        private System.Windows.Forms.Label label4;
        private System.Windows.Forms.Label label5;
        private System.Windows.Forms.Label label6;
        private System.Windows.Forms.TreeView colorTree;
        private System.Windows.Forms.Button button1;
        private System.Windows.Forms.Panel panel2;
        private System.Windows.Forms.Label label7;
        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.Container components = null;

        public Form1()
        {
            //
            // Required for Windows Form Designer support
            //
            InitializeComponent();
            colorTree.AfterSelect += new TreeViewEventHandler(ColorTree_AfterSelect);
            BuildWheel();
            //
            // TODO: Add any constructor code after InitializeComponent call
            //
        }

        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }
        private void BuildWheel()
        {
            // Wzy nadrzdne w kontrolce typu TreeView bd reprezentoway poszczeglne segmenty koa barw.
            TreeNode tNode;
            tNode = colorTree.Nodes.Add("Red");
            tNode = colorTree.Nodes.Add("Orange");
            tNode = colorTree.Nodes.Add("Yellow");
            tNode = colorTree.Nodes.Add("Yellow-Green");
            tNode = colorTree.Nodes.Add("Green");
            tNode = colorTree.Nodes.Add("Green-Cyan");
            tNode = colorTree.Nodes.Add("Cyan");
            tNode = colorTree.Nodes.Add("Blue-Cyan");
            tNode = colorTree.Nodes.Add("Blue");
            tNode = colorTree.Nodes.Add("Blue-Magenta");
            tNode = colorTree.Nodes.Add("Magenta");
            tNode = colorTree.Nodes.Add("Red-Magenta");


        }

        #region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            this.panel1 = new System.Windows.Forms.Panel();
            this.rText = new System.Windows.Forms.TextBox();
            this.gText = new System.Windows.Forms.TextBox();
            this.bText = new System.Windows.Forms.TextBox();
            this.hText = new System.Windows.Forms.TextBox();
            this.sText = new System.Windows.Forms.TextBox();
            this.lText = new System.Windows.Forms.TextBox();
            this.label1 = new System.Windows.Forms.Label();
            this.label2 = new System.Windows.Forms.Label();
            this.label3 = new System.Windows.Forms.Label();
            this.label4 = new System.Windows.Forms.Label();
            this.label5 = new System.Windows.Forms.Label();
            this.label6 = new System.Windows.Forms.Label();
            this.colorTree = new System.Windows.Forms.TreeView();
            this.button1 = new System.Windows.Forms.Button();
            this.panel2 = new System.Windows.Forms.Panel();
            this.label7 = new System.Windows.Forms.Label();
            this.SuspendLayout();
            // 
            // panel1
            // 
            this.panel1.BackColor = System.Drawing.SystemColors.ActiveCaptionText;
            this.panel1.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.panel1.Location = new System.Drawing.Point(16, 32);
            this.panel1.Name = "panel1";
            this.panel1.Size = new System.Drawing.Size(112, 88);
            this.panel1.TabIndex = 0;
            // 
            // rText
            // 
            this.rText.Location = new System.Drawing.Point(16, 144);
            this.rText.Name = "rText";
            this.rText.Size = new System.Drawing.Size(32, 20);
            this.rText.TabIndex = 1;
            this.rText.Text = "";
            // 
            // gText
            // 
            this.gText.Location = new System.Drawing.Point(56, 144);
            this.gText.Name = "gText";
            this.gText.Size = new System.Drawing.Size(32, 20);
            this.gText.TabIndex = 2;
            this.gText.Text = "";
            // 
            // bText
            // 
            this.bText.Location = new System.Drawing.Point(96, 144);
            this.bText.Name = "bText";
            this.bText.Size = new System.Drawing.Size(32, 20);
            this.bText.TabIndex = 3;
            this.bText.Text = "";
            // 
            // hText
            // 
            this.hText.Location = new System.Drawing.Point(16, 184);
            this.hText.Name = "hText";
            this.hText.Size = new System.Drawing.Size(32, 20);
            this.hText.TabIndex = 4;
            this.hText.Text = "";
            // 
            // sText
            // 
            this.sText.Location = new System.Drawing.Point(56, 184);
            this.sText.Name = "sText";
            this.sText.Size = new System.Drawing.Size(32, 20);
            this.sText.TabIndex = 5;
            this.sText.Text = "";
            // 
            // lText
            // 
            this.lText.Location = new System.Drawing.Point(96, 184);
            this.lText.Name = "lText";
            this.lText.Size = new System.Drawing.Size(32, 20);
            this.lText.TabIndex = 6;
            this.lText.Text = "";
            // 
            // label1
            // 
            this.label1.Location = new System.Drawing.Point(24, 128);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(16, 16);
            this.label1.TabIndex = 7;
            this.label1.Text = "R";
            // 
            // label2
            // 
            this.label2.Location = new System.Drawing.Point(64, 128);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(16, 16);
            this.label2.TabIndex = 8;
            this.label2.Text = "G";
            // 
            // label3
            // 
            this.label3.Location = new System.Drawing.Point(104, 128);
            this.label3.Name = "label3";
            this.label3.Size = new System.Drawing.Size(16, 16);
            this.label3.TabIndex = 9;
            this.label3.Text = "B";
            // 
            // label4
            // 
            this.label4.Location = new System.Drawing.Point(24, 168);
            this.label4.Name = "label4";
            this.label4.Size = new System.Drawing.Size(16, 16);
            this.label4.TabIndex = 10;
            this.label4.Text = "H";
            // 
            // label5
            // 
            this.label5.Location = new System.Drawing.Point(64, 168);
            this.label5.Name = "label5";
            this.label5.Size = new System.Drawing.Size(16, 16);
            this.label5.TabIndex = 11;
            this.label5.Text = "S";
            // 
            // label6
            // 
            this.label6.Location = new System.Drawing.Point(104, 168);
            this.label6.Name = "label6";
            this.label6.Size = new System.Drawing.Size(16, 16);
            this.label6.TabIndex = 12;
            this.label6.Text = "L";
            // 
            // colorTree
            // 
            this.colorTree.ImageIndex = -1;
            this.colorTree.Location = new System.Drawing.Point(200, 32);
            this.colorTree.Name = "colorTree";
            this.colorTree.SelectedImageIndex = -1;
            this.colorTree.Size = new System.Drawing.Size(160, 168);
            this.colorTree.TabIndex = 13;
            // 
            // button1
            // 
            this.button1.Location = new System.Drawing.Point(216, 208);
            this.button1.Name = "button1";
            this.button1.Size = new System.Drawing.Size(128, 24);
            this.button1.TabIndex = 14;
            this.button1.Text = "Buduj drzewo kolorw";
            this.button1.Click += new System.EventHandler(this.button1_Click);
            // 
            // panel2
            // 
            this.panel2.BackColor = System.Drawing.SystemColors.ActiveCaptionText;
            this.panel2.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.panel2.Location = new System.Drawing.Point(144, 32);
            this.panel2.Name = "panel2";
            this.panel2.Size = new System.Drawing.Size(32, 88);
            this.panel2.TabIndex = 15;
            // 
            // label7
            // 
            this.label7.Location = new System.Drawing.Point(136, 120);
            this.label7.Name = "label7";
            this.label7.Size = new System.Drawing.Size(64, 16);
            this.label7.TabIndex = 16;
            this.label7.Text = "Jasno";
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(392, 237);
            this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.label7,
																		  this.panel2,
																		  this.button1,
																		  this.colorTree,
																		  this.label6,
																		  this.label5,
																		  this.label4,
																		  this.label3,
																		  this.label2,
																		  this.label1,
																		  this.lText,
																		  this.sText,
																		  this.hText,
																		  this.bText,
																		  this.gText,
																		  this.rText,
																		  this.panel1});
            this.Name = "Form1";
            this.Text = "Przegldarka kolorw GDI+";
            this.ResumeLayout(false);

        }
        #endregion

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main()
        {
            Application.Run(new Form1());
        }

        private void button1_Click(object sender, System.EventArgs e)
        {
            /* Add Colors to TreeNode Structure
               Loop through KnownColor enum values
               First, makes sure nodes have not been added
            */
            if (colorTree.Nodes[0].FirstNode == null)
            {
                Array objColor = Enum.GetValues(typeof(KnownColor));
                for (int i = 0; i < objColor.Length; i++)
                {
                    KnownColor kc = (KnownColor)objColor.GetValue(i);
                    Color c = Color.FromKnownColor(kc);
                    if (!c.IsSystemColor) // Wycza kolory systemowego interfejsu uytkownika.
                    {
                        InsertColor(c, c.GetHue());
                    }
                }
            }
        }
        private void InsertColor(Color myColor, float hue)
        {
            TreeNode tNode;
            TreeNode cNode = new TreeNode();
            float hueOffset = hue + 15;
            if (hueOffset > 360) hueOffset = hueOffset - 360;
            // Wyznacza jedn z dwunastu kategorii barw.
            int colorCat = (int)(hueOffset - .1) / 30;
            tNode = colorTree.Nodes[colorCat];
            //Color myColor = Color.FromKnownColor(kc);
            // Zapisuje wartoci systemu HSB we waciwoci Tag wza.
            HSB nodeHSB = new HSB(hue, myColor.GetSaturation(), myColor.GetBrightness());
            cNode.Tag = nodeHSB;			// Waciwo Tag zawiera od teraz wartoci HSB.
            cNode.Text = myColor.Name;		// Nazwa koloru.
            int nodeCt = tNode.Nodes.Count;
            bool insert = false;
            // Wstawia kolory w kolejnoci zgodne z wartociami barwy systemu HSB.
            for (int i = 0; i < nodeCt && insert == false; i++)
            {
                nodeHSB = (HSB)tNode.Nodes[i].Tag;
                if (hue < nodeHSB.Hue)
                {
                    tNode.Nodes.Insert(i, cNode);
                    insert = true;
                }
            }
            if (!insert) tNode.Nodes.Add(cNode);
        }
        private void ColorTree_AfterSelect(Object sender, TreeViewEventArgs e)
        {
            // Wywietla kolor zaznaczonego wza.
            TreeNode tn = e.Node;
            if (e.Node.Parent != null) ShowColor(e.Node);

        }
        public struct HSB
        {
            public float Hue;
            public float Saturation;
            public float Brightness;
            public HSB(float H, float S, float B)
            {
                Hue = H;
                Saturation = S;
                Brightness = B;
            }
        }
        private void ShowColor(TreeNode viewNode)
        {
            Graphics g = panel1.CreateGraphics();
            Graphics g2 = panel2.CreateGraphics();
            try
            {
                string nodeColor = viewNode.Text;
                Color myColor = Color.FromName(viewNode.Text); // convert name to color
                Brush b = new SolidBrush(myColor);
                // Wywietla wybrany kolor.
                g.FillRectangle(b, 0, 0, panel1.Width, panel1.Height);
                HSB hsbVal = (HSB)viewNode.Tag;
                //double h = hsbVal.Hue;
                //h = ((double) h / 360 * 255)  ;
                //int huescaled= (int)h;
                int huescaled = (int)(hsbVal.Hue / 360 * 255);
                hText.Text = huescaled.ToString();
                sText.Text = hsbVal.Saturation.ToString();
                lText.Text = hsbVal.Brightness.ToString();
                rText.Text = myColor.R.ToString();
                gText.Text = myColor.G.ToString();
                bText.Text = myColor.B.ToString();
                // Rysuje skal jasnoci.
                Rectangle rect = new Rectangle(new Point(0, 0), new Size(panel2.Width, panel2.Height));
                LinearGradientBrush bg = new LinearGradientBrush(rect, Color.Red, Color.Red, 90);
                ColorBlend myBlend = new ColorBlend();
                myBlend.Colors = new Color[] { Color.White, myColor, Color.Black };
                myBlend.Positions = new float[] { 0f, 1 - hsbVal.Brightness, 1f };
                bg.InterpolationColors = myBlend;
                g2.FillRectangle(bg, rect);
                int colorPt = (int)((1 - hsbVal.Brightness) * panel1.Height);
                // Rysuje wskanik na skali jasnoci reprezentujcej biecy kolor.
                g2.FillRectangle(Brushes.White, 0, colorPt, 10, 2);
                b.Dispose();
                bg.Dispose();
            }
            finally
            {
                g.Dispose();
                g2.Dispose();
            }
        }

    }
}
