using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;
using System.Drawing.Imaging;
using System.Drawing.Drawing2D;
// Rozdzia 8: Przegldarka obrazw
namespace GDI_Images
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem menuItem2;
		private System.Windows.Forms.MenuItem menuItem3;
		private System.Windows.Forms.MenuItem menuItem4;
		private System.Windows.Forms.MenuItem menuItem5;
		private System.Windows.Forms.MenuItem menuItem7;
		private System.Windows.Forms.MenuItem menuItem8;
		private System.Windows.Forms.MenuItem menuItem9;
		private System.Windows.Forms.Panel panel1;
		private Bitmap bmp;
		private Bitmap newBmp;
		private Bitmap smallBmp;
		private int resizeLevel;
		private bool ImageStatus = false;
		private bool rotateorflip = false;
		private Point lastPoint = Point.Empty;
		private Point origPoint = Point.Empty;
		private Rectangle rectSel;
		private bool selectStatus = false;
		private System.Windows.Forms.Panel panel2;
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.Button button2;
		private System.Windows.Forms.MenuItem menuLoad;
		private System.Windows.Forms.MenuItem menuItem6;
		private System.Windows.Forms.MenuItem menuItem10;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Form1()
		{
			InitializeComponent();
			panel1.MouseDown += new MouseEventHandler(Mouse_Down);
			panel1.MouseUp   += new MouseEventHandler(Mouse_Up);
			panel1.MouseMove += new MouseEventHandler(Mouse_Move);
			panel1.Paint     += new PaintEventHandler(RePaint);
		}

		// Zwalnia wszystkie zajte zasoby.
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		private void InitializeComponent()
		{
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.menuLoad  = new System.Windows.Forms.MenuItem();
			this.menuItem7 = new System.Windows.Forms.MenuItem();
			this.menuItem2 = new System.Windows.Forms.MenuItem();
			this.menuItem3 = new System.Windows.Forms.MenuItem();
			this.menuItem4 = new System.Windows.Forms.MenuItem();
			this.menuItem5 = new System.Windows.Forms.MenuItem();
			this.menuItem8 = new System.Windows.Forms.MenuItem();
			this.menuItem9 = new System.Windows.Forms.MenuItem();
			this.panel1 = new System.Windows.Forms.Panel();
			this.panel2 = new System.Windows.Forms.Panel();
			this.button1 = new System.Windows.Forms.Button();
			this.button2 = new System.Windows.Forms.Button();
			this.menuItem6 = new System.Windows.Forms.MenuItem();
			this.menuItem10 = new System.Windows.Forms.MenuItem();
			this.SuspendLayout();
			// 
			// mainMenu1
			// 
			this.mainMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					this.menuItem1,
																					this.menuItem2,
																					this.menuItem8});
			// 
			// menuItem1
			// 
			this.menuItem1.Index = 0;
			this.menuItem1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					this.menuLoad,
																					this.menuItem7,
																					this.menuItem6});
			this.menuItem1.Text = "Plik";
			// 
			// menuLoad
			// 
			this.menuLoad.Index = 0;
			this.menuLoad.Text = "Otwrz";
			this.menuLoad.Click += new System.EventHandler(this.menuItem6_Click);
			// 
			// menuItem7
			// 
			this.menuItem7.Index = 1;
			this.menuItem7.Text = "Zapisz";
			// 
			// menuItem2
			// 
			this.menuItem2.Index = 1;
			this.menuItem2.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					this.menuItem3,
																					this.menuItem4,
																					this.menuItem5,
																					this.menuItem10});
			this.menuItem2.Text = "Obraz";
			// 
			// menuItem3
			// 
			this.menuItem3.Index = 0;
			this.menuItem3.Text = "Odwr";
			this.menuItem3.Click += new System.EventHandler(this.menuItem3_Click);
			// 
			// menuItem4
			// 
			this.menuItem4.Index = 1;
			this.menuItem4.Text = "Odbicie lustrzane";
			this.menuItem4.Click += new System.EventHandler(this.menuItem4_Click);
			// 
			// menuItem5
			// 
			this.menuItem5.Index = 2;
			this.menuItem5.Text = "Kopiuj";
			this.menuItem5.Click += new System.EventHandler(this.menuItem5_Click);
			// 
			// menuItem8
			// 
			this.menuItem8.Index = 2;
			this.menuItem8.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					this.menuItem9});
			this.menuItem8.Text = "Ekran";
			// 
			// menuItem9
			// 
			this.menuItem9.Index = 0;
			this.menuItem9.Text = "Odwie";
			this.menuItem9.Click += new System.EventHandler(this.menuItem9_Click);
			// 
			// panel1
			// 
			this.panel1.AutoScroll = true;
			this.panel1.BackColor = System.Drawing.SystemColors.ActiveCaptionText;
			this.panel1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.panel1.Location = new System.Drawing.Point(8, 32);
			this.panel1.Name = "panel1";
			this.panel1.Size = new System.Drawing.Size(192, 128);
			this.panel1.TabIndex = 0;
			// 
			// panel2
			// 
			this.panel2.BackColor = System.Drawing.Color.White;
			this.panel2.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.panel2.Location = new System.Drawing.Point(224, 32);
			this.panel2.Name = "panel2";
			this.panel2.Size = new System.Drawing.Size(144, 104);
			this.panel2.TabIndex = 1;
			// 
			// button1
			// 
			this.button1.BackColor = System.Drawing.SystemColors.Control;
			this.button1.Font = new System.Drawing.Font("Microsoft Sans Serif", 8F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.button1.ForeColor = System.Drawing.SystemColors.ControlDarkDark;
			this.button1.Location = new System.Drawing.Point(248, 144);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(24, 16);
			this.button1.TabIndex = 2;
			this.button1.Text = "+";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// button2
			// 
			this.button2.BackColor = System.Drawing.SystemColors.Control;
			this.button2.Font = new System.Drawing.Font("Microsoft Sans Serif", 8F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.button2.Location = new System.Drawing.Point(312, 144);
			this.button2.Name = "button2";
			this.button2.Size = new System.Drawing.Size(24, 16);
			this.button2.TabIndex = 3;
			this.button2.Text = "-";
			this.button2.Click += new System.EventHandler(this.button2_Click);
			// 
			// menuItem6
			// 
			this.menuItem6.Index = 2;
			this.menuItem6.Text = "Wklej obraz";
			this.menuItem6.Click += new System.EventHandler(this.menuItem6_Click_1);
			// 
			// menuItem10
			// 
			this.menuItem10.Index = 3;
			this.menuItem10.Text = "Skaluj do okna";
			this.menuItem10.Click += new System.EventHandler(this.menuItem10_Click_1);
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.BackColor = System.Drawing.Color.OldLace;
			this.ClientSize = new System.Drawing.Size(384, 177);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		this.button2,
																		this.button1,
																		this.panel2,
																		this.panel1});
			this.Menu = this.mainMenu1;
			this.Name = "Form1";
			this.Text = "Przegldarka obrazw GDI+";
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		private void menuItem6_Click(object sender, System.EventArgs e)
		{
			// Wczytuje plik obrazu za pomoc odpowiedniego okna dialogowego.
			OpenFileDialog fd = new OpenFileDialog();
			fd.InitialDirectory = "c:\\" ;
			fd.Filter = "Pliki graficzne | *.JPG;*.GIF";
			if (fd.ShowDialog() == DialogResult.OK)
			{
				string fname= fd.FileName;
				using(Graphics g = panel1.CreateGraphics())
				{
					bmp = new Bitmap(fname); // Wczytuje obraz z pliku.
					newBmp = bmp;	         // Tworzy kopi obrazu.
					Rectangle r = new Rectangle(0,0,bmp.Width,
						bmp.Height);
					g.FillRectangle(Brushes.White,0,0,panel1.Width,panel1.Height );
					g.DrawImage(bmp,r);      // Rysuje obraz w obszarze panelu.
					ImageStatus = true;      // Okrela, czy dany obraz istnieje.
					rotateorflip=false;
					// Usuwa ca zawarto mniejszego panelu.
					Graphics gClear= panel2.CreateGraphics();
					gClear.FillRectangle(Brushes.White,0,0,panel2.Width,panel2.Height);
					gClear.Dispose();
				}
			}			
		}

		private void menuItem4_Click(object sender, System.EventArgs e)
		{
			// Tworzy odbicie lustrzane obrazu.
			if(ImageStatus)
			{
				Graphics g= panel1.CreateGraphics();
				int h = newBmp.Height;
				int w = newBmp.Width;
				Point[] destPts = {
									  new Point(w,0),
									  new Point(0,0),
									  new Point(w,h) };
				Bitmap tempBmp = new Bitmap(newBmp.Width,newBmp.Height);
				Graphics gr= Graphics.FromImage(tempBmp);
				gr.DrawImage(newBmp, destPts);
				g.DrawImage(tempBmp,0,0);
				newBmp = tempBmp;
				rotateorflip=true;
				g.Dispose();
				gr.Dispose();
			}
		}

		private void menuItem3_Click(object sender, System.EventArgs e)
		{
			// Odwraca obraz.
			if(ImageStatus)
			{
				newBmp.RotateFlip(RotateFlipType.RotateNoneFlipY);
				Graphics g= panel1.CreateGraphics();
				Rectangle r = new Rectangle(0,0,newBmp.Width,newBmp.Height);
				g.DrawImage(newBmp,0,0);
				rotateorflip = true;
				g.Dispose();
			}
		}

		private void menuItem9_Click(object sender, System.EventArgs e)
		{
			// Odwiea zawarto ekranu.
			panel1.Invalidate();
			panel1.Update();
			selectStatus = false;
		}

		private void menuItem5_Click(object sender, System.EventArgs e)
		{
			// Kopiuje zaznaczony obszar do drugiego panelu.
			if (selectStatus)
			{				
				Bitmap temp=null;
				Rectangle rd;
				Graphics g = panel2.CreateGraphics();
				g.FillRectangle(Brushes.White,panel2.ClientRectangle);
				
				if(newBmp.Width!= bmp.Width && !rotateorflip) 
				{
					Rectangle r= TransformRect();
					rd = new Rectangle(0,0,r.Width,r.Height);
					temp = new Bitmap(r.Width,r.Height);
					Graphics gi = Graphics.FromImage(temp);				 
					
					gi.DrawImage(bmp,rd,r,GraphicsUnit.Pixel);
				}
				else
				{				 
					rd = new Rectangle(0,0,rectSel.Width,rectSel.Height);
					temp = new Bitmap(rectSel.Width,rectSel.Height);
					Graphics gi = Graphics.FromImage(temp);				 
					
					gi.DrawImage(newBmp,rd,rectSel,GraphicsUnit.Pixel);
				}
				smallBmp = temp;
				g.DrawImage(smallBmp,rd);  // Rysuje obraz w mniejszym panelu.
				g.Dispose();
				resizeLevel=0;
			}					
		}

		private Rectangle TransformRect()
		{
			// Przeksztaca zaznaczony prostokt.
			decimal transRatio= (decimal)bmp.Width/(decimal)newBmp.Width;
			Rectangle r= new Rectangle();
			r.X= (int)((decimal)rectSel.X*transRatio);
			r.Y= (int)((decimal)rectSel.Y*transRatio);
			r.Width= (int)((decimal)rectSel.Width*transRatio);
			r.Height= (int)((decimal)rectSel.Height*transRatio);
			return r;
		}
		private void RePaint(object sender, PaintEventArgs e)
		{
			Graphics g = e.Graphics;
			int w= e.ClipRectangle.Width;
			int h = e.ClipRectangle.Height;
			if (ImageStatus) 
				g.DrawImage(newBmp,e.ClipRectangle,e.ClipRectangle,GraphicsUnit.Pixel);
			
			base.OnPaint(e);
		}
		private void Mouse_Down(object sender, MouseEventArgs e)
		{			
			if (lastPoint != Point.Empty)
			{
				panel1.Invalidate(rectSel);
				panel1.Update();
			}			
			lastPoint.X= e.X;
			lastPoint.Y= e.Y;
			origPoint = lastPoint;
			selectStatus=true;
		}
		private void Mouse_Up(object sender, MouseEventArgs e)
		{
			if (e.X > origPoint.X)
			{
				rectSel.X= origPoint.X;
				rectSel.Y = origPoint.Y;
			} 
			else 
			{
				rectSel.X= e.X;
				rectSel.Y= origPoint.Y;
			}
			rectSel.Width = Math.Abs(e.X- origPoint.X)+1;
			rectSel.Height= Math.Abs(e.Y - origPoint.Y)+1;
			origPoint = Point.Empty;
			if (rectSel.Width < 2) selectStatus=false;			
		}
		private void Mouse_Move(object sender, MouseEventArgs e)
		{
			if (origPoint != Point.Empty)
			{				
				Rectangle r;
				Rectangle rd;
				int xop = origPoint.X;
				if (xop > lastPoint.X) xop= lastPoint.X;
				int w = Math.Abs(origPoint.X - lastPoint.X)+1;
				int h = lastPoint.Y - origPoint.Y+1;
				r = new Rectangle(xop,origPoint.Y,w,h);
				//
				xop = e.X >= origPoint.X ? origPoint.X:e.X;
				w = Math.Abs(origPoint.X - e.X);
				h = e.Y - origPoint.Y;
				rd = new Rectangle(xop, origPoint.Y,w,h);
				Graphics g = panel1.CreateGraphics();
				g.DrawImage(newBmp,r,r,GraphicsUnit.Pixel);
				g.DrawRectangle(Pens.Red,rd);
				g.Dispose();
				lastPoint.X= e.X;
				lastPoint.Y= e.Y;				 
			}
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
			// Powiksza obraz.
			Graphics g = panel2.CreateGraphics();
			if (smallBmp != null) 
			{
				resizeLevel= resizeLevel+1;
				float fac= (float) (1.0+(resizeLevel*.25));
				int w = (int)(smallBmp.Width*fac);
				int h =(int) (smallBmp.Height*fac);
				Rectangle rd= new Rectangle(0,0,w,h);
				Bitmap tempBmp = new Bitmap(w,h);
				Graphics gi = Graphics.FromImage(tempBmp);
				gi.DrawImage(smallBmp,rd);
				g.DrawImage(tempBmp,rd);
				//smallBmp = tempBmp;
				gi.Dispose();
			}
			g.Dispose();
		}

		private void button2_Click(object sender, System.EventArgs e)
		{
			// Zmniejsza obraz.
			Graphics g = panel2.CreateGraphics();
			resizeLevel= (resizeLevel>-3)?resizeLevel-1:resizeLevel;
			float fac= (float) (1.0+(resizeLevel*.25));
			int w = (int)(smallBmp.Width*fac);
			int h =(int) (smallBmp.Height*fac);
			g.FillRectangle(Brushes.White,panel1.ClientRectangle);
			Rectangle rd= new Rectangle(0,0,w,h);
			Bitmap tempBmp = new Bitmap(w,h);
			Graphics gi = Graphics.FromImage(tempBmp);
			gi.DrawImage(smallBmp,rd);
			g.DrawImage(tempBmp,rd);
			gi.Dispose();
			g.Dispose();
		}

		

		private void menuItem6_Click_1(object sender, System.EventArgs e)
		{
			// Wkleja obraz skadowany w schowku w obszarze panelu.
			IDataObject clip = Clipboard.GetDataObject();
			//MessageBox.Show(clip.GetType().ToString());
			if (clip.GetDataPresent(DataFormats.Bitmap,true) )
			{
				bmp = (Bitmap) clip.GetData(DataFormats.Bitmap,true);
				Graphics g = panel1.CreateGraphics();
				g.FillRectangle(Brushes.White,panel1.ClientRectangle);
				g.DrawImage(bmp,0,0);
				newBmp= bmp;
				ImageStatus = true;  
				rotateorflip=false;
			}
		}

		private void menuItem10_Click_1(object sender, System.EventArgs e)
		{
			// Skaluje obraz do wymiarw panelu docelowego.
			// Obraz moe by skalowany pod warunkiem, e nie zastosowano efekt odbicia lustrzanego ani odwrcenia.
			if(!rotateorflip && ImageStatus)
			{
				using (Graphics g = panel1.CreateGraphics())
				{
					g.FillRectangle(Brushes.White,panel1.ClientRectangle);
					decimal panelRatio = (decimal)panel1.Width/(decimal)panel1.Height;
					decimal bmpRatio = (decimal)newBmp.Width/(decimal)newBmp.Height;
					int w= panel1.Width;
					int h= panel1.Height;
					if(panelRatio==bmpRatio)  // Panel i obraz maj ten sam stosunek wysokoci do szerokoci.
					{
						w=panel1.Width;
						h=panel1.Height;
					}
					else
					{
						if (panelRatio> bmpRatio)
						{
							h= (int) panel1.Height;
							w= (int) (((decimal)h/(decimal)newBmp.Height)*(decimal)newBmp.Width );
						}
						else
						{
							w= (int) panel1.Width;
							h= (int) (((decimal)w/ (decimal)newBmp.Width)*(decimal)newBmp.Height);
						}
					}
					Rectangle dRect= new Rectangle(new Point(0,0),new Size(w, h));
					g.DrawImage(newBmp,dRect);
					//
					Bitmap bmpMem = new Bitmap(w,h);
					Graphics gmem= Graphics.FromImage(bmpMem);
					gmem.DrawImage(bmp,dRect);
					newBmp= bmpMem;
				}
			}		
		}
	}
}
