using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace winform
{
	// Formularz wykorzystujcy efekt przezroczystoci podczas tworzenia nieregularnego ksztatu.
	//
	public class CustomForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Panel panel1;
		private System.Windows.Forms.Panel panel2;
		private System.Windows.Forms.Panel panel3;
		private System.Windows.Forms.Panel panel4;
		private System.Windows.Forms.PictureBox pictureBox1;
		// Mj kod
		private Point lastPoint = Point.Empty;
		private System.Windows.Forms.Button button1;
		//
		private System.ComponentModel.Container components = null;

		public CustomForm()
		{
			//
			// Wymagane do obsugi Windows Form Designer.
			//
			InitializeComponent();

			this.pictureBox1.MouseDown += new MouseEventHandler(OnMouseDown);
			this.pictureBox1.MouseUp   += new MouseEventHandler(OnMouseUp);
			this.pictureBox1.MouseMove += new MouseEventHandler(OnMouseMove);
		}

		// Zwalnia wszystkie wykorzystywane zasoby.
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		//
		private void InitializeComponent()
		{
			//System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(CustomForm));
			
			this.panel1 = new System.Windows.Forms.Panel();
			this.panel2 = new System.Windows.Forms.Panel();
			this.panel3 = new System.Windows.Forms.Panel();
			this.panel4 = new System.Windows.Forms.Panel();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.button1 = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// panel1
			// 
			this.panel1.BackColor = System.Drawing.Color.Red;
			this.panel1.Location = new System.Drawing.Point(208, 0);
			this.panel1.Name = "panel1";
			this.panel1.Size = new System.Drawing.Size(72, 56);
			this.panel1.TabIndex = 0;
			// 
			// panel2
			// 
			this.panel2.BackColor = System.Drawing.Color.Red;
			this.panel2.Name = "panel2";
			this.panel2.Size = new System.Drawing.Size(72, 56);
			this.panel2.TabIndex = 1;
			// 
			// panel3
			// 
			this.panel3.BackColor = System.Drawing.Color.Red;
			this.panel3.Location = new System.Drawing.Point(0, 144);
			this.panel3.Name = "panel3";
			this.panel3.Size = new System.Drawing.Size(72, 56);
			this.panel3.TabIndex = 1;
			// 
			// panel4
			// 
			this.panel4.BackColor = System.Drawing.Color.Red;
			this.panel4.Location = new System.Drawing.Point(208, 144);
			this.panel4.Name = "panel4";
			this.panel4.Size = new System.Drawing.Size(72, 56);
			this.panel4.TabIndex = 1;
			// 
			// pictureBox1
			// 
			//this.pictureBox1.Image = ((System.Drawing.Bitmap)(  .GetObject("pictureBox1.Image")));
			pictureBox1.Image = Image.FromFile(@".\obrazy\x.gif");
			this.pictureBox1.Location = new System.Drawing.Point(120, 64);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(40, 40);
			this.pictureBox1.TabIndex = 2;
			this.pictureBox1.TabStop = false;
			// 
			// button1
			// 
			this.button1.BackColor = System.Drawing.SystemColors.Control;
			this.button1.Location = new System.Drawing.Point(112, 112);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(56, 24);
			this.button1.TabIndex = 3;
			this.button1.Text = "Zamknij";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// CustomForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.BackColor = System.Drawing.Color.Gray;
			this.ClientSize = new System.Drawing.Size(280, 197);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.button1,
																		  this.pictureBox1,
																		  this.panel1,
																		  this.panel2,
																		  this.panel3,
																		  this.panel4});
			this.Name = "CustomForm";
			this.Text = "Nistandardowy formularz";
			this.ResumeLayout(false);

		}
		 

        private void OnMouseDown(object sender, MouseEventArgs e)
		{         
			lastPoint.X = e.X;
			lastPoint.Y = e.Y;			 
		}
   
		private void OnMouseUp(object sender, MouseEventArgs e)
		{			 
			lastPoint = Point.Empty;
		} 

		private void OnMouseMove(object sender, MouseEventArgs e)
		{
			if (lastPoint != Point.Empty) 
			{
			 // Przenosi formularz w nowe miejsce.
				int xInc = e.X - lastPoint.X;
				int yInc = e.Y - lastPoint.Y;
				this.Location = new Point(this.Left + xInc, this.Top+yInc);
			}
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
			this.Close();
		} 
	}
}

