﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reactive.Subjects;
using System.Text;
using System.Threading.Tasks;

namespace RxSubjects
{
    class Example35
    {
        // Listing 11-35
        public class KeyWatcher
        {
            private readonly Subject<char> _subject = new Subject<char>();

            public IObservable<char> Keys { get { return _subject; } }

            public void Run()
            {
                while (true)
                {
                    _subject.OnNext(Console.ReadKey(true).KeyChar);
                }
            }
        }

        public static void WatchKeysIndefinite()
        {
            var keySource = new KeyWatcher();
            keySource.Keys.Subscribe(k => Console.WriteLine("Klawisz: " + k));
            keySource.Run();
        }
    }
}
