﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reactive.Concurrency;
using System.Reactive.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace Scheduling
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();

            // Listing 11-31
            IObservable<Trade> trades = GetTradeStream();
            IObservable<Trade> tradesInUiContext =
                trades.ObserveOn(DispatcherScheduler.Current);
            tradesInUiContext.Subscribe(t =>
            {
                tradeInfoTextBox.AppendText(string.Format(
                    "{0}: {1} at {2}\r\n", t.StockName, t.Number, t.UnitPrice));
            });

            // Deklaracja i przypisanie określające wartość zmiennej tradeInUiContext może być zastąpione
            // dowolną z poniższych instrukcji:
            // Listing 11-32
            //IObservable<Trade> tradesInUiContext = trades.ObserveOn(this.Dispatcher);
            // Listing 11-33
            //IObservable<Trade> tradesInUiContext = trades.ObserveOnDispatcher();
        }

        private IObservable<Trade> GetTradeStream()
        {
            // Dodanie losowych opóźnień do elementów i dostarczenie ich przy użyciu
            // wątku z puli wątków TPL, by pokazać, że mechanizm szeregujący jest
            // w stanie dostarczać je do wątku obsługi interfejsu użytkownika.
            Random r = new Random(0);
            double totalDelay = 0.2;
            return Trade.TestStream()
                .Delay(t => Observable.Timer(TimeSpan.FromSeconds(totalDelay += r.NextDouble())))
                .ObserveOn(TaskPoolScheduler.Default);
        }
    }
}
