﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Operators
{
    class Examples63_65
    {
        public static void FailingSequenceCast()
        {
            try
            {
                // Listing 10-63
                IEnumerable<object> sequence = Course.Catalog.Select(c => (object) c);
                var courseSequence = (IEnumerable<Course>) sequence; // Zgłasza InvalidCastException
            }
            catch (Exception x)
            {
                Console.WriteLine(x);
            }
        }

        public static void SequenceCast()
        {
            IEnumerable<object> sequence = Course.Catalog.Select(c => (object) c);


            // Listing 10-64
            var courseSequence = sequence.Cast<Course>();

            courseSequence.Show();
        }

        public static void CreateLookup()
        {
            // Listing 10-65
            ILookup<string, Course> categoryLookup =
                Course.Catalog.ToLookup(course => course.Category);
            foreach (Course c in categoryLookup["MAT"])
            {
                Console.WriteLine(c.Title);
            }
        }
    }
}
