﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Synchronization
{
    class Example15
    {
        // Listing 17-15
        static int InterlockedIncrement(ref int target)
        {
            int current, newValue;
            do
            {
                current = target;
                newValue = current + 1;
            }
            while (Interlocked.CompareExchange(ref target, newValue, current)
                    != current);
            return newValue;
        }
    }
}
