﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reactive;
using System.Reactive.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Adaptation
{
    class Examples39_40
    {
        public static void WrapEvent()
        {
            // Listing 11-39
            string path = Environment.GetFolderPath(Environment.SpecialFolder.MyPictures);
            var watcher = new FileSystemWatcher(path);
            watcher.EnableRaisingEvents = true;

            IObservable<EventPattern<FileSystemEventArgs>> changes =
                Observable.FromEventPattern<FileSystemEventArgs>(watcher, "Created");
            IDisposable sub = changes.Subscribe(evt => Console.WriteLine(evt.EventArgs.FullPath));
            // Uwaga: kolejny wiersz jest inny niż w tekście książki, aby można było usunąć
            // subskrypcję przed przejściem do następnego przykładu.

            Console.WriteLine("Obserwacja zmian w systemie plików. Naciśnij dowolny kalwisz by kontynuować.");
            Console.ReadKey();
            sub.Dispose();
        }

        public static void WrapEventUsingDelegates()
        {
            string path = Environment.GetFolderPath(Environment.SpecialFolder.MyPictures);
            var watcher = new FileSystemWatcher(path);
            watcher.EnableRaisingEvents = true;

            // Listing 11-40
            IObservable<EventPattern<FileSystemEventArgs>> changes =
                Observable.FromEventPattern<FileSystemEventHandler, FileSystemEventArgs>(
                h => watcher.Created += h, h => watcher.Created -= h);

            IDisposable sub = changes.Subscribe(evt => Console.WriteLine(evt.EventArgs.FullPath));
            Console.WriteLine("Obserwacja zmian w systemie plików. Naciśnij dowolny kalwisz by kontynuować.");
            Console.ReadKey();
            sub.Dispose();
        }
    }
}
