﻿using System;
using System.Reactive.Subjects;

namespace RxSubjects
{
    class Example34
    {
        // Listing 11-34
        public class KeyWatcher : IObservable<char>
        {
            private readonly Subject<char> _subject = new Subject<char>();

            public IDisposable Subscribe(IObserver<char> observer)
            {
                return _subject.Subscribe(observer);
            }

            public void Run()
            {
                while (true)
                {
                    _subject.OnNext(Console.ReadKey(true).KeyChar);
                }
            }
        }

        public static void WatchKeysIndefinite()
        {
            var keySource = new KeyWatcher();
            keySource.Subscribe(k => Console.WriteLine("Klawisz: " + k));
            keySource.Run();
        }
    }
}
