﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace DeferredQueries
{
    class Program
    {
        static void Main(string[] args)
        {
            // Listing 10-14
            var commaCultures =
                from culture in CultureInfo.GetCultures(CultureTypes.AllCultures)
                where culture.NumberFormat.NumberDecimalSeparator == ","
                select culture;

            object[] numbers = { 1, 100, 100.2, 10000.2 };

            foreach (object number in numbers)
            {
                foreach (CultureInfo culture in commaCultures)
                {
                    Console.WriteLine(string.Format(culture, "{0}: {1:c}",
                                      culture.Name, number));
                }
            }
        }
    }
}
