﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Text;
using System.Threading.Tasks;

namespace Delegates
{
    class Examples36_38
    {
        public static void LambdaExpression()
        {
            // Listing 9-36
            Expression<Func<int, bool>> greaterThanZero = value => value > 0;
        }

        public static void LambdaExpressionByHand()
        {
            // Listing 9-37
            ParameterExpression valueParam = Expression.Parameter(typeof(int), "value");
            ConstantExpression constantZero = Expression.Constant(0);
            BinaryExpression comparison = Expression.GreaterThan(valueParam, constantZero);
            Expression<Func<int, bool>> greaterThanZero =
                Expression.Lambda<Func<int, bool>>(comparison, valueParam);

        }

        public static void ExpressionInDbQuery()
        {
            using (var dbContext = new MyDataEntities())
            {
                // Listing 9-38
                var expensiveProducts = dbContext.Products.Where(p => p.ListPrice > 3000);

                foreach (var p in expensiveProducts)
                {
                    Console.WriteLine("{0}: ${1}", p.Name, p.ListPrice);
                }
            }
        }
    }
}
