﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Threads
{
    class Example1
    {
        // Listing 17-1
        public static string FormatDictionary<TKey, TValue>(
            IDictionary<TKey, TValue> input)
        {
            var sb = new StringBuilder();
            foreach (var item in input)
            {
                sb.AppendFormat("{0}: {1}", item.Key, item.Value);
                sb.AppendLine();
            }

            return sb.ToString();
        }

        public static void ConcurrentMethodInvocation()
        {
            var d = new Dictionary<string, int> { { "jeden", 1 }, { "dwa", 2 }, { "trzy", 3 } };
            Task<string>[] tasks = Enumerable.Range(1, 10).Select(x => Task<string>.Factory.StartNew(() => FormatDictionary(d))).ToArray();
            Task.WaitAll(tasks);
            foreach (Task<string> task in tasks)
            {
                Console.WriteLine(task.Result);
            }
        }
    }
}
