﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Inheritance
{
    // Listing 6-20
    public class BaseWithVirtual
    {
        public virtual void ShowMessage()
        {
            Console.WriteLine("Witamy w metodzie BaseWithVirtual");
        }
    }

    // Listing 6-22
    public class DeriveWithoutOverride : BaseWithVirtual
    {
    }

    public class DeriveAndOverride : BaseWithVirtual
    {
        public override void ShowMessage()
        {
            Console.WriteLine("Ta metoda przesłania metodę wirtualną!");
        }
    }


    class Examples20_23
    {
        // Listing 6-21
        public static void CallVirtualMethod(BaseWithVirtual o)
        {
            o.ShowMessage();
        }

        public static void PassBase()
        {
            CallVirtualMethod(new BaseWithVirtual());
        }

        public static void UsingVirtualMethods()
        {
            // Listing 6-23
            CallVirtualMethod(new BaseWithVirtual());
            CallVirtualMethod(new DeriveWithoutOverride());
            CallVirtualMethod(new DeriveAndOverride());
        }
    }
}
