﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Files
{
    class Examples18_20
    {
        public static void SearchForFiles()
        {
            // Listing 16-18
            foreach (string file in Directory.GetFiles(@"c:\users\ian\Pictures",
                                           "*.jpg",
                                           SearchOption.AllDirectories))
            {
                Console.WriteLine(file);
            }
        }

        public static void DisplayInfo()
        {
            // Listing 16-19
            var fi = new FileInfo(@"c:\temp\log.txt");
            Console.WriteLine("{0} ({1} bytes) last modified on {2}",
                fi.FullName, fi.Length, fi.LastWriteTime);
        }

        public static void SettingsLocation()
        {
            // Listing 16-20
            string appSettingsRoot =
                Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData);
            string myAppSettingsFolder =
                Path.Combine(appSettingsRoot, @"InteractSoftwareLtd\FrobnicatorPro");
        }
    }
}
