﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Runtime.CompilerServices;
using System.Text;
using System.Threading.Tasks;

namespace CallerInfoAttributes
{
    // Listing 15-12
    public class NotifyPropertyChanged : INotifyPropertyChanged
    {
        public event PropertyChangedEventHandler PropertyChanged;

        protected void OnPropertyChanged(
            [CallerMemberName] string propertyName = null)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
            }
        }
    }

    // Listing 15-13
    public class MyViewModel : NotifyPropertyChanged
    {
        private string _name;

        public string Name
        {
            get
            {
                return _name;
            }
            set
            {
                if (value != _name)
                {
                    _name = value;
                    OnPropertyChanged();
                }
            }
        }
    }

    class Examples12_13
    {
        public static void RaisePropertyChange()
        {
            var vm = new MyViewModel();
            vm.PropertyChanged += (s, e) => Console.WriteLine("Właściwość została zmieniona: " + e.PropertyName);
            vm.Name = "Foo";
        }
    }
}
