﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Events
{
    // Listing 9-39
    public class Eventful
    {
        public event Action<string> Announcement;

        public void Announce(string message)
        {
            if (Announcement != null)
            {
                Announcement(message);
            }
        }
    }

    class Examples39_43
    {
        public static void HandlingEvents()
        {
            // Listing 9-40
            var source = new Eventful();
            source.Announcement += m => Console.WriteLine("Zdarzenie Announcement: " + m);

            // Zgłaszamy
            source.Announce("Oto oświadczenie. I to już wszystko.");
        }

        // Commented out because this shows an error.
        //public static void HowNotToRaiseAnEvent()
        //{
        //    // Listing 9-41
        //    var source = new Eventful();
        //    source.Announcement("Czy to zadziala?"); // Nie, tego kodu nie uda się skompilować!
        //}


        // Listing 9-42
        private Action<string> Announcement;

        // To nie jest kod, którego by można użyć w praktyce.
        // Faktyczny kod jest znacznie bardziej złożony, gdyż musi zapewnić
        // możliwość obsługi wywołań współbieżnych 
        public void add_Announcement(Action<string> handler)
        {
            Announcement += handler;
        }
        public void remove_Announcement(Action<string> handler)
        {
            Announcement -= handler;
        }

        // Kod umieszczony w komentarzu gdyż reprezentuje typ zdefiniowany 
        // w bibliotece klas .NET Framework
        //// Listing 9-43
        //public delegate void EventHandler(object sender, EventArgs e);
    }
}
