﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace NestedHandling
{
    class Program
    {
        // Listing 8-6
        static void Main(string[] args)
        {
            try
            {
                PrintFirstLineLength(@"C:\Temp\File.txt");
            }
            catch (NullReferenceException)
            {
                Console.WriteLine("NullReferenceException");
            }
        }

        static void PrintFirstLineLength(string fileName)
        {
            try
            {
                using (var r = new StreamReader(fileName))
                {
                    try
                    {
                        Console.WriteLine(r.ReadLine().Length);
                    }
                    catch (IOException x)
                    {
                        Console.WriteLine("Błąd podczas odczytu pliku: {0}",
                            x.Message);
                    }
                }
            }
            catch (FileNotFoundException x)
            {
                Console.WriteLine("Nie udało się odnaleźć pliku '{0}'", x.FileName);
            }
        }
    }
}
