using System;

namespace Exercises
{
	interface IConvertible
	{
		string ConvertToCSharp(string stringToConvert);
		string ConvertToVB2005(string stringToConvert);
	}

	interface ICodeChecker : IConvertible
	{
		bool CheckCodeSyntax(string stringToCheck, string whichLang);
	}

	public class ProgramConverter : IConvertible
	{
		public ProgramConverter()
		{
			Console.WriteLine("Tworzenie obiektu ProgramConverter");
		}

		public virtual string ConvertToCSharp(string stringToConvert)
		{
			return "Przeksztacam podany acuch znakw na kod w jzyku C#";
		}

		public virtual string ConvertToVB2005(string stringToConvert)
		{
			return "Przeksztacam podany acuch znakw na kod w jzyku VB 2005";
		}

	}

	public class ProgramHelper : ProgramConverter, ICodeChecker
	{
		public ProgramHelper()
		{
			Console.WriteLine("Tworzenie obiektu ProgramHelper");
		}

		public bool CheckCodeSyntax(string stringToCheck, string whichLang)
		{
			switch (whichLang)
			{
				case "CSharp":
					Console.WriteLine(
					   "Sprawdzam skadni jzyka C# w acuchu \"{0}\"", stringToCheck);
					return true;
				case "VB2005":
					Console.WriteLine(
					   "Sprawdzam skadni jzyka VB 2005 w acuchu \"{0}\"",
					   stringToCheck);
					return true;
				default:
					return false;
			} // Koniec switch
		}    // Koniec CheckCodeSyntax
	}       // Koniec ProgramHelper

	class Tester
	{

		static void Main()
		{
			Tester t = new Tester();
			t.Run();
		}

		public void Run()
		{
			ProgramConverter[] converters = new ProgramConverter[4];
			converters[0] = new ProgramConverter();
			converters[1] = new ProgramHelper();
			converters[2] = new ProgramHelper();
			converters[3] = new ProgramConverter();

			foreach (ProgramConverter pc in converters)
			{
				string vbString =
				   pc.ConvertToCSharp("Public Sub Read() Implements IStorable.Read " +
				   "Console.WriteLine(\"Implementacja metody Read interfejsu IStorable\")"
				   + "End Sub 'Read\")");

				Console.WriteLine(vbString);

				ProgramHelper ph = pc as ProgramHelper;
				if (ph != null)
				{
					ph.CheckCodeSyntax(vbString, "VB2005");
				}
				else
				{
					Console.WriteLine(
					   "Bez sprawdzania skadni VB - to nie obiekt ProgramHelper");
				}

				string cSharpString = pc.ConvertToCSharp(vbString);
				Console.WriteLine(cSharpString);
				if (ph != null)
				{
					ph.CheckCodeSyntax(vbString, "CSharp");
				}
				else
				{
					Console.WriteLine(
					   "Bez sprawdzania skadni C# - to nie obiekt ProgramHelper");
				}
			} // Koniec foreach in converters
		}    // Koniec run
	}       // Koniec Tester
}          // Koniec namespace

