﻿using System;

namespace Properties
{
    public class Time
    {
        // prywatne zmienne składowe
        private int year;
        private int month;
        private int date;
        private int hour;
        private int minute;
        private int second;

        // utworzenie właściwości
        public int Hour
        {
            get
            {
                return hour;
            }
            set
            {
                hour = value;
            }
        }

        // publiczne metody akcesora
        public void DisplayCurrentTime()
        {
            System.Console.WriteLine("Czas: {0}/{1}/{2} {3}:{4}:{5}", month, date, year,
               hour, minute, second);
        }

        // konstruktory
        public Time(System.DateTime dt)
        {
            year = dt.Year;
            month = dt.Month;
            date = dt.Day;
            hour = dt.Hour;
            minute = dt.Minute;
            second = dt.Second;
        }
    }

    class Tester
    {
        public void Run()
        {
            System.DateTime currentTime = System.DateTime.Now;
            Time t = new Time(currentTime);
            t.DisplayCurrentTime();

            // udostępnienie godziny lokalnej zmiennej
            int theHour = t.Hour;

            // wyświetlenie godziny
            System.Console.WriteLine("Otrzymana godzina: {0}", theHour);

            // inkrementacja godziny
            theHour++;

            // ponowne przypisanie zwiększonej wartości poprzez właściwość
            t.Hour = theHour;

            // wyświetlenie właściwości
            System.Console.WriteLine("Zaktualizowana godzina: {0}", t.Hour);
        }

        [STAThread]
        static void Main()
        {
            Tester t = new Tester();
            t.Run();
        }
    }
}