using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Rozdzial18Cwiczenie2
{
	public partial class OrderForm : Form
	{
		public OrderForm()
		{
			InitializeComponent();
			ResetValues();
			ResetDeliveryDate();
		}

		// Po klikniciu przycisku Add program zeruje nastpny wybr
		// i dodaje biece zamwienie do koszyka
		private void btnAdd_Click(object sender, EventArgs e)
		{
			ResetValues();
			SaveToShoppingCart();
		}

		// Ustawia wszystkie kontrolki na ich wyjciowe wartoci
		private void ResetValues()
		{
			this.ddlBooks.SelectedIndex = -1;
			this.ddlBooks.Text = "Prosz wybra ksik";
			this.numCopies.Value = 1;
			this.rbHardcover.Checked = false;
			this.rbLibrary.Checked = false;
			this.rbPaperback.Checked = true;
			this.cbConfirm.Checked = false;
			this.cbGiftWrap.Checked = false;
			this.cbRush.Checked = false;
		}

		// Oddzielone, jeli trzeba ustawi je odrbnie
		private void ResetDeliveryDate()
		{
			// Minimalny czas dostawy to dwa dni
			this.deliveryDate.MinDate = DateTime.Now + new TimeSpan(2, 0, 0, 0);
			// Inicjowanie kontrolki zmienn MinDate
			this.deliveryDate.Value = this.deliveryDate.MinDate;
		}

		// Obsuguje koszyk zakupw i aktualizacj statusu 
		private void SaveToShoppingCart()
		{
			// Tu operacje do zapisu wyborw
			this.lblStatus.Text = "Dodano do koszyka zakupw.";
		}

		// Powoduje, e uycie dowolnej kontrolki innej ni przycisk
		// zeruje status (aby unikn problemw)
		private void UniversalEventHandler(object sender, EventArgs e)
		{
			this.lblStatus.Text = string.Empty;
		}

	} // Koniec klasy
}    // Koniec przestrzeni nazw
