#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <signal.h>

void error(char *msg)
{
  fprintf(stderr, "%s: %s\n", msg, strerror(errno));
  exit(1);
}


int open_listener_socket()
{
  int s = socket(PF_INET, SOCK_STREAM, 0);
  if (s == -1)
    error("Nie mona otworzy gniazda");
  return s;
}

void bind_to_port(int socket, int port)
{
  struct sockaddr_in name;
  name.sin_family = PF_INET;
  name.sin_port = (in_port_t)htons(30000);
  name.sin_addr.s_addr = htonl(INADDR_ANY);
  int reuse = 1;
  if (setsockopt(socket, SOL_SOCKET, SO_REUSEADDR, (char *)&reuse, sizeof(int)) == -1)
    error("Nie mona ustawi opcji ponownego uycia gniazda");
  int c = bind (socket, (struct sockaddr *) &name, sizeof(name));
  if (c == -1)
    error("Nie mona utworzy powizania z gniazdem");
}


int listener_d;
void handle_shutdown(int sig)
{
  if (listener_d)
    close(listener_d);

  fprintf(stderr, "Na razie!\n");
  exit(0);
}


int main(int argc, char *argv[])
{
  if (catch_signal(SIGINT, handle_shutdown) == -1)
    error("Nie mona ustawi procedury obsugi przerwania");
  listener_d = open_listener_socket();
  bind_to_port(listener_d, 30000);
  if (listen(listener_d, 10) == -1)
    error("Nie mona odbiera pocze");
  struct sockaddr_storage client_addr;
  unsigned int address_size = sizeof(client_addr);
  puts("Czekam na poczenie");
  char buf[255];

  while (1) {
    int connect_d = accept(listener_d, (struct sockaddr *)&client_addr, &address_size);

    if (connect_d == -1)
      error("Nie mona otworzy pomocniczego gniazda");

    if (!fork()) {
      close(listener_d);
      if (say(connect_d,
              "Internetowy Serwer Protokou Puk-Puk\r\nWerska 1.0\r\nPuk-puk!\r\n> ")
          != -1) {
        read_in(connect_d, buf, sizeof(buf));

        if (strncasecmp("Kto tam?", buf, 12))
          say(connect_d, "Powiniene zapyta: 'Kto tam?'!");
        else {
          if (say(connect_d, "Oskar\r\n> ") != -1) {
            read_in(connect_d, buf, sizeof(buf));
            if (strncasecmp("Jaki Oskar?", buf, 10))
              say(connect_d, "Powiniene zapyta: 'Jaki Oskar?'!\r\n");
            else
              say(connect_d, "Oskar, gupie pytanie, na ktre dostaniesz gupi odpowied.\r\n");
          }
        }
      }
      close(connect_d);
      exit(0);
    }
    close(connect_d);
  }


  return 0;
}
