/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#include <iostream>
#include <vector>
#include <cstdlib>
#include "stack6.hpp"

int main()
{
    try {
        CPPBook::Stack<int>         intStack;       // stos wartoci cakowitych
        CPPBook::Stack<float>       floatStack;     // stos wartoci zmiennoprzecinkowych

        // operacje na stosie wartoci zmiennoprzecinkowych
        floatStack.push(7.7);

        // operacje na stosie wartoci cakowitych
        intStack.push(42);
        intStack.push(7);

        floatStack = intStack;
        floatStack.push(3.1415);
        std::cout << floatStack.top() << std::endl;
        floatStack.pop();
        std::cout << floatStack.top() << std::endl;
        floatStack.pop();
        std::cout << floatStack.top() << std::endl;
        floatStack.pop();

        CPPBook::Stack<int,std::vector<int> > vStack;       // stos wartoci cakowitych
        vStack.push(42);
        vStack.push(7);
        std::cout << vStack.top() << std::endl;
        vStack.pop();
    }
    catch (const char* msg) {
        std::cerr << "Exception: " << msg << std::endl;
        return EXIT_FAILURE;
    }
}

