/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#include <iostream>
#include <string>
#include <cstdlib>
#include "stack5.hpp"

int main()
{
    try {
        Stack<int>   intStack;       // stos wartoci cakowitych
        Stack<float> floatStack;     // stos wartoci zmiennoprzecinkowych

        // operacje na stosie wartoci cakowitych
        intStack.push(42);
        intStack.push(7);

        // operacje na stosie wartoci zmiennoprzecinkowych
        floatStack.push(7.7);

        // przypisanie stosu innego typu
        floatStack = intStack;

        // wywietla zawarto stosu wartoci zmiennoprzecinkowych
        std::cout << floatStack.top() << std::endl;
        floatStack.pop();
        std::cout << floatStack.top() << std::endl;
        floatStack.pop();
        std::cout << floatStack.top() << std::endl;
        floatStack.pop();
    }
    catch (std::exception const& ex) {
        std::cerr << "Wyjtek: " << ex.what() << std::endl;
        return EXIT_FAILURE;  
    }
}

