/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#include <iostream>
#include <string>
#include <cstdlib>
#include "stack4.hpp"

int main()
{
    try {
        CPPBook::Stack<int,20>         int20Stack;   // stos 20 wartoci cakowitych
        CPPBook::Stack<int,40>         int40Stack;   // stos 40 wartoci cakowitych
        CPPBook::Stack<std::string,40> stringStack;  // stos 40 acuchw

        // operacje na stosie liczb cakowitych 
        int20Stack.push(7);
        std::cout << int20Stack.top() << std::endl;
        int20Stack.pop();

        // operacje na stosie acuchw
        std::string s = "hello";
        stringStack.push(s);
        std::cout << stringStack.top() << std::endl; 
        stringStack.pop();
        std::cout << stringStack.top() << std::endl;
        stringStack.pop();
    }
    catch (const char* msg) {
        std::cerr << "Wyjtek: " << msg << std::endl;
        return EXIT_FAILURE;
    }
}

