/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#include <iostream>
#include <deque>
#include <cstdlib>
#include "stack3.hpp"

int main()
{
    try {
        // stos liczb cakowitych
        CPPBook::Stack<int> intStack;
        // stos liczb zmiennoprzecinkowych
        CPPBook::Stack<double,std::deque<double> > dblStack;

        // operacje na stosie liczb cakowitych
        intStack.push(7);
        std::cout << intStack.top() << std::endl;
        intStack.pop();

        // operacje na stosie liczb zmiennoprzecinkowych
        dblStack.push(42.42);
        std::cout << dblStack.top() << std::endl; 
        dblStack.pop();
        std::cout << dblStack.top() << std::endl;
        dblStack.pop();
    }
    catch (const char* msg) {
        std::cerr << "Wyjtek: " << msg << std::endl;
        return EXIT_FAILURE;
    }
}

