/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

// rysuje obiekt geometryczny
template <typename GeoObj>
void myDraw (const GeoObj& obj)
{
    obj.draw();
}

// wyznacza odlego pomidzy dwoma obiektami
template <typename GeoObj1, typename GeoObj2>
Coord distance (const GeoObj1& x1, const GeoObj2& x2)
{
    Coord a = x1.position() - x2.position();
    return a.abs();
}

// rysuje heterogeniczn kolekcj obiektw geometrycznych
template <typename GeoObj>
void drawElems (const std::vector<GeoObj>& elems)
{
    for (unsigned i=0; i<elems.size(); ++i) {
        elems[i].draw();
    }
}

int main()
{
    Line l;
    Circle c;
    Circle c1, c2;

    myDraw(l);          // myDraw<Line>(GeoObj&) => Line::draw()
    myDraw(c);          // myDraw<Circle>(GeoObj&) => Circle::draw()

    distance(c1,c2);    // distance<Circle,Circle>(GeoObj&,GeoObj&)
    distance(l,c);      // distance<Line,Circle>(GeoObj&,GeoObj&)

    // std::vector<GeoObj*> coll;  // BD: heterogeniczna kolekcja nie jest dozwolona
    std::vector<Line> coll;      // homogeniczna kolekcja
    coll.push_back(l);           // wstawia odcinek
    drawElems(coll);             // rysuje kolekcj
}

