/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#include <deque>
#include <algorithm>
#include <stdexcept>

namespace CPPBook {  // ******** Pocztek przestrzeni nazw CPPBook::

template <typename T, typename CONT = std::deque<T> >
class Stack {
  private:
    CONT elems;  // elementy

  public:
    Stack();               // konstruktor
    void push(const T&);   // umieszcza nowy element na szczycie
    void pop();            // usuwa element ze szczytu
    T top() const;         // zwraca element znajdujcy si na szczycie
    bool empty() const {   // sprawdza, czy stos jest pusty
        return elems.empty();
    }

    // przypisanie stosu o elementach typu T2
    template <typename T2, typename CONT2>
    Stack<T,CONT>& operator= (const Stack<T2,CONT2>&);
};

// konstruktor
template <typename T, typename CONT>
Stack<T,CONT>::Stack ()
{
    // nie wykonuje adnych instrukcji
}

template <typename T, typename CONT>
void Stack<T,CONT>::push (const T& elem)
{
    elems.push_back(elem);    // umieszcza element na szczycie
}

template<typename T, typename CONT>
void Stack<T,CONT>::pop ()
{
    if (elems.empty()) {
        throw std::out_of_range("Stack<>::pop(): pusty stos");
    }
    elems.pop_back();         // usuwa element ze szczytu
}

template <typename T, typename CONT>
T Stack<T,CONT>::top () const
{
    if (elems.empty()) {
        throw std::out_of_range("Stack<>::top(): pusty stos");
    }
    return elems.back();      // zwraca kopi elementu znajdujcego si na szczycie
}

template <typename T, typename CONT>
 template <typename T2, typename CONT2>
Stack<T,CONT>& Stack<T,CONT>::operator= (const Stack<T2,CONT2>& op2)
{
    if ((void*)this == (void*)&op2) {    // przypisanie do samego siebie?
        return *this;
    }

    Stack<T2,CONT2> tmp(op2);        // tworzy kopi przypisywanego stosu

    elems.clear();                   // usuwa elementy
    while (!tmp.empty()) {           // kopiuje elementy
        elems.push_front(tmp.top());
        tmp.pop();
    }
    return *this;
}

}  // ******** Koniec przestrzeni nazw CPPBook::

