/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

template <typename T>
class Stack {
  private:
    std::deque<T> elems;   // elementy

  public:
    void push(const T&);   // umieszcza nowy element na szczycie
    void pop();            // usuwa element ze szczytu
    T top() const;         // zwraca element znajdujcy si na szczycie
    bool empty() const {   // sprawdza, czy stos jest pusty
        return elems.empty();
    }

    // przypisanie stosu o elementach typu T2
    template <typename T2>
    Stack<T>& operator= (Stack<T2> const&);
};

