/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#include <stdexcept>

// **** Pocztek przestrzeni nazw CPPBook ********************************
namespace CPPBook {

template <typename T, int MAXSIZE>
class Stack {
  private:
    T elems[MAXSIZE];     // elementy
    int numElems;         // bieca liczba elementw na stosie

  public:
    Stack();              // konstruktor
    void push(const T&);  // umieszcza nowy element na szczycie
    void pop();           // usuwa element ze szczytu
    T top() const;        // zwraca element znajdujcy si na szczycie
};

// konstruktor
template <typename T, int MAXSIZE>
Stack<T,MAXSIZE>::Stack()
  : numElems(0)    // brak elementw
{
    // nie wykonuje adnych instrukcji
}

template <typename T, int MAXSIZE>
void Stack<T,MAXSIZE>::push(const T& elem)
{
    if (numElems == MAXSIZE) {
        throw std::out_of_range("Stack<>::push(): peen stos");
    }
    elems[numElems] = elem;   // umieszcza element w tablicy
    ++numElems;               // zwiksza liczb elementw na stosie
}

template<typename T, int MAXSIZE>
void Stack<T,MAXSIZE>::pop()
{
    if (numElems <= 0) {
        throw std::out_of_range("Stack<>::pop(): pusty stos");
    }
    --numElems;               // zmniejsza liczb elementw
}

template <typename T, int MAXSIZE>
T Stack<T,MAXSIZE>::top() const
{
    if (numElems <= 0) {
        throw std::out_of_range("Stack<>::top(): pusty stos");
    }
    return elems[numElems-1];  // zwraca kopi elementu znajdujcego si na szczycie
}

} // **** Koniec przestrzeni nazw CPPBook ********************************

