/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#include <deque>
#include <string>
#include <stdexcept>

// **** Pocztek przestrzeni nazw CPPBook ********************************
namespace CPPBook {

template<>
class Stack<std::string> {
  private:
    std::deque<std::string> elems;  // elementy

  public:
    Stack() {                       // konstruktor
    }
    void push(const std::string&);  // umieszcza nowy element na szczycie
    void pop();                     // usuwa element ze szczytu
    std::string top() const;        // zwraca element znajdujcy si na szczycie
};

void Stack<std::string>::push(const std::string& elem)
{
    elems.push_back(elem);          // umieszcza element na szczycie
}

void Stack<std::string>::pop()
{
    if (elems.empty()) {
        throw std::out_of_range
                    ("Stack<std::string>::pop(): pusty stos");
    }
    elems.pop_back();               // usuwa element ze szczytu 
}

std::string Stack<std::string>::top() const
{
    if (elems.empty()) {
        throw std::out_of_range
                    ("Stack<std::string>::top(): pusty stos");
    }
    return elems.back();            // zwraca kopi elementu znajdujcego si na szczycie
}

} // **** Koniec przestrzeni nazw CPPBook ********************************

