/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#include <iostream>
#include <cstring>

// zwraca wiksz z dwch wartoci dowolnego typu
template <typename T>
inline const T& max (const T& a, const T& b)
{
    std::cout << "max<>() dla T" << std::endl;
    return  a < b  ?  b : a;
}

// dla dwch wskanikw
template <typename T>
inline T* const& max (T* const& a, T* const& b)
{
    std::cout << "max<>() dla T*" << std::endl;
    return  *a < *b  ?  b : a;
}

// dla dwch C-acuchw
inline const char* const& max (const char* const& a,
                               const char* const& b)
{ 
    std::cout << "max<>() dla char*" << std::endl;
    return  std::strcmp(a,b) < 0  ?  b : a;
}

