/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#ifndef EXPLDEF_HPP
#define EXPLDEF_HPP

#include "expl.hpp"
#include <stdexcept>

// definicja szablonu funkcji max()
template <typename T>
const T& max(const T& a, const T& b)
{
    return (a > b ? a : b);
}

// definicja funkcji szablonu klasy Stack<>

// **** Pocztek przestrzeni nazw CPPBook ********************************
namespace CPPBook {

// konstruktor
template <typename T>
Stack<T>::Stack()
{
    // nie wykonuje adnych instrukcji
}

template <typename T>
void Stack<T>::push(const T& elem)
{
    elems.push_back(elem);    // umieszcza kopi obiektu na szczycie stosu
}

template<typename T>
void Stack<T>::pop()
{
    if (elems.empty()) {
        throw std::out_of_range("Stack<>::pop(): pusty stos");
    }
    elems.pop_back();         // usuwa element ze szczytu stosu
}

template <typename T>
T Stack<T>::top() const
{
    if (elems.empty()) {
        throw std::out_of_range("Stack<>::top(): pusty stos");
    }
    return elems.back();      // zwraca kopi elementu znajdujcego si na szczycie
}

} // **** Koniec przestrzeni nazw CPPBook ********************************

#endif // EXPLDEF_HPP

