/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#ifndef EXPL_HPP
#define EXPL_HPP

// deklaracja szablonu funkcji max()
template <typename T>
const T& max(const T& a, const T& b);

// deklaracja szablonu klasy Stack<>
#include <vector>

// **** Pocztek przestrzeni nazw CPPBook ********************************
namespace CPPBook {

template <typename T>
class Stack {
  private:
    std::vector<T> elems;  // elementy
  public:
    Stack();               // konstruktor
    void push(const T&);   // umieszcza element na szczycie stosu
    void pop();            // usuwa element ze szczytu
    T top() const;         // zwraca element znajdujcy si na szczycie
};

} // **** Koniec przestrzeni nazw CPPBook ********************************

#endif // EXPL_HPP

