/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

// rysuje obiekt geometryczny
void myDraw (const GeoObj& obj)
{
    obj.draw();
}

// wyznacza odlego pomidzy dwoma obiektami
Coord distance (const GeoObj& x1, const GeoObj& x2)
{
    Coord a = x1.position() - x2.position();
    return a.abs();
}

// rysuje heterogeniczn kolekcj obiektw geometrycznych
void drawElems (const std::vector<GeoObj*>& elems)
{
    for (unsigned i=0; i<elems.size(); ++i) {
        elems[i]->draw();
    }
}

int main()
{
    Line l;
    Circle c, c1, c2;

    myDraw(l);              // myDraw(GeoObj&) => Line::draw()
    myDraw(c);              // myDraw(GeoObj&) => Circle::draw()

    distance(c1,c2);        // distance(GeoObj&,GeoObj&)
    distance(l,c);          // distance(GeoObj&,GeoObj&)

    std::vector<GeoObj*> coll;  // heterogeniczna kolekcja
    coll.push_back(&l);         // wstawia odcinek
    coll.push_back(&c);         // wstawia okrg
    drawElems(coll);            // rysuje kolekcj
}

