/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#include "coord.hpp"

// wsplna abstrakcyjna klasa bazowa GeoObj obiektw geometrycznych
class GeoObj {
  public:
    // rysuje obiekt geometryczny:
    virtual void draw() const = 0;
    // zwraca pooenie obiektu geometrycznego:
    virtual Coord position() const = 0;
    //...
};

// konkretna klasa obiektu geometrycznego Circle
// - klasa pochodna klasy GeoObj
class Circle : public GeoObj {
  public:
    virtual void draw() const;
    virtual Coord position() const;
    //...
};

// konkretna klasa obiektu geometrycznego Line
// - klasa pochodna klasy GeoObjGeoObj
class Line : public GeoObj {
  public:
    virtual void draw() const;
    virtual Coord position() const;
    //...
};
//...

