/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#include <iostream>
#include <map>
#include <string>

int main()
{
    // typ kolekcji
    typedef std::multimap<int,std::string> IntStringMMap;

    IntStringMMap coll;    // kontener klasy multimap, ktrego elementami s pary int/string

    // wstawia nieuporzdkowane elementy
    // - w tym dwa elementy o kluczu 5
    coll.insert(std::make_pair(5,"heavy"));
    coll.insert(std::make_pair(2,"best"));
    coll.insert(std::make_pair(1,"The"));
    coll.insert(std::make_pair(4,"are:"));
    coll.insert(std::make_pair(5,"long"));
    coll.insert(std::make_pair(3,"parties"));

    /* wywietla wszystkie wartoci
     * - kolekcja przegldana jest za pomoc iteratora
     * - dostp do wartoci elementu za pomoc second
     */
    IntStringMMap::iterator pos;
    for (pos = coll.begin(); pos != coll.end(); ++pos) {
        std::cout << pos->second << ' ';
    }
    std::cout << std::endl;
}

