/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#include <iostream>
#include <vector>
#include <algorithm>
#include <string>
#include <iterator>

int main()
{
    using namespace std;    // wszystkie symbole przestrzni nazw std staj si globalne

    vector<string> coll;    // wektor o elementach klasy string

    /* wczytuje acuchy znakw ze standardowego wejcia a do koca danych
     * - kopiuje zawarto kolekcji wejciowej cin do kolekcji coll
     */
    copy(istream_iterator<string>(cin),    // pocztek zakresu rdowego
         istream_iterator<string>(),       // koniec zakresu rdowego
         back_inserter(coll));             // zakres docelowy

    // sortuje elementy kolekcji coll
    sort(coll.begin(), coll.end());

    /* wywietla wszystkie elementy
     * - kopiuje elementy kolekcji coll do kolekcji wyjciowej cout
     * - kady acuch zostaje wywietlony w osobnym wierszu (oddzielony znakiem "\n")
     */
    copy(coll.begin(), coll.end(),              // zakres rdowy
         ostream_iterator<string>(cout,"\n"));  // zakres docelowy
}

