/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#include <iostream>
#include <vector>
#include <algorithm>
#include <string>

int main()
{
    std::vector<std::string> coll;            // kontener, ktrego elemantami s acuchy znakw
    std::vector<std::string>::iterator pos;   // iterator

    // wstawia nazwy miast
    coll.push_back("Hamburg");
    coll.push_back("Monachium");
    coll.push_back("Berlin");
    coll.push_back("Brunszwik");
    coll.push_back("Duisburg");
    coll.push_back("Lipsk");

    // sortuje ca kolekcj
    std::sort(coll.begin(), coll.end());

    /* wstawia "Hanower" przed "Hamburg"
     * - odnajduje pozycj elementu "Hamburg"
     * - wstawia przed niego "Hannover"
     */
    pos = find(coll.begin(), coll.end(),    // zakres
               "Hamburg");                  // kryteria wyszukiwania
    if (pos != coll.end()) {
        coll.insert(pos,"Hanover");
    }
    else {
        std::cerr << "Hamburg nie znajduje si w kontenerze!" << std::endl;
        coll.push_back("Hanover");
    }

    // wywietla wszystkie elementy kontenera
    for (pos=coll.begin(); pos!=coll.end(); ++pos) {
        std::cout << *pos << ' ';
    }
    std::cout << std::endl;
}

