/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#include <iostream>
#include <vector>
#include <algorithm>

int main()
{
    std::vector<int> coll;             // wektor o elementach typu int
    std::vector<int>::iterator pos;    // iterator

    // wstawia nieposortowane elementy o wartociach od 1 do 6
    coll.push_back(2);
    coll.push_back(5);
    coll.push_back(4);
    coll.push_back(1);
    coll.push_back(6);
    coll.push_back(3);

    // wywietla najmniejszy i najwiekszy element kolekcji
    pos = std::min_element(coll.begin(), coll.end());
    std::cout << "min: " << *pos << std::endl;
    pos = std::max_element(coll.begin(), coll.end());
    std::cout << "max: " << *pos << std::endl;

    // sortuje elementy kolekcji wzrastajco
    std::sort(coll.begin(), coll.end());

    // odwraca uporzdkowanie elementw
    std::reverse(coll.begin(), coll.end());

    // wywietla wszystkie elementy
    for (pos=coll.begin(); pos!=coll.end(); ++pos) {
        std::cout << *pos << ' ';
    }
    std::cout << std::endl;
}

