/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#include <iostream>    // plik nagwkowy operacji wejcia i wyjcia
#include <string>      // plik nagwkowy z deklaracj typu string

int main()
{
    const std::string start("http:");           // pocztek cza HTML
    const std::string separator (" \"\t\n<>");  // znaki koczce cze
    std::string line;                           // biecy wiersz
    std::string link;                           // biece cze HTML
    std::string::size_type begIdx, endIdx;      // indeksy

    // dla kadego pomylnie wczytanego wiersza
    while (getline(std::cin,line)) {
        // poszukuje pierwszego wystpienia acucha "http:"
        begIdx = line.find(start);

        // gdy pocztek cza "http:" zosta znaleziony w wierszu
        while (begIdx != std::string::npos) {
            // znajduje koniec cza
            endIdx = line.find_first_of(separator,begIdx);

            // wyodrbnia cze
            if (endIdx != std::string::npos) {
                // wyodrbnia acuch od pocztku do koca cza
                link = line.substr(begIdx,endIdx-begIdx);
            }
            else {
                // koniec nie zosta znaleziony: uywa reszty wiersza
                link = line.substr(begIdx);
            }

            // wywietla cze
            // - ignoruje "http:" nie zawierajce specyfikacji adresu
            if (link != "http:") {
                link = std::string("cze: ") + link;
                std::cout << link << std::endl;
            }

            // poszukuje kolejnego cza w wierszu
            if (endIdx != std::string::npos) {
                // poszukuje kolejnego wystpienia acucha "http:" zaczynajc od koca poprzedneigo cza
                begIdx = line.find(start,endIdx);
            }
            else {
                // kocem cza by koniec wiersza: nie jest potrzebny nowy indeks pocztkowy
                begIdx = std::string::npos;
            }
        }
    }
}

