/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#include <iostream>    // plik nagwkowy operacji wejcia i wyjcia
#include <string>      // plik nagwkowy klasy string
#include <cstdlib>     // plik nagwkowy zawierajcy EXIT_FAILURE
#include <exception>   // plik nagwkowy wyjtkw

void processException()
{
    try {
        throw;    // wyrzuca wyjatek ponownie
                  // aby mg zosta tutaj obsuony
    }
    catch (const std::bad_alloc& e) {
        // specjalny wyjtek: brak wolnej pamici
        std::cerr << "brak pamici" << std::endl;
    }
    catch (const std::exception& e) {
        // inne wyjtki standardowe
        std::cerr << "standardowy wyjtek: " << e.what() << std::endl;
    }
    catch (...) {
        // wszystkie pozostae wyjtki
        std::cerr << "inny wyjtek" << std::endl;
    }
}

int main()
{
    try {
        // tworzy dwa acuchy znakw
        std::string firstname("bjarne");    // moe wyrzuci wyjtek std::bad_alloc
        std::string lastname("stroustrup"); // moe wyrzuci wyjtek std::bad_alloc
        std::string name;

        // manipulacje acuchami
        firstname.at(20) = 'B';             // wyrzuca std::out_of_range
        lastname[30] = 'S';                 // BD: nieokrelone zachowanie

        // konkatenuje acuchy
        name = firstname + " " + lastname;  // moe wyrzuci wyjtek std::bad_alloc
    }
    catch (...) {
        // obsuguje wszystkie wyjtki za pomoc funkcji pomocniczej
        processException();
        return EXIT_FAILURE;    // opuszcza main() zwracajc kod bdu
    }

    std::cout << "OK, wykonanie programu przebiego pomylnie"
              << std::endl;
}

