/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#include <iostream>
#include <fstream>
#include <string>

void redirect(std::ostream&,const std::string&);

int main()
{
    std::cout << "pierwszy wiersz" << std::endl;

    redirect(std::cout, "redirect.txt"); // przekierowanie cout do pliku redirect.txt

    std::cout << "ostatni wiersz" << std::endl;
}

void redirect(std::ostream& strm, const std::string& filename)
{
    // otwiera plik (z buforem) do zapisu
    std::ofstream file(filename.c_str());

    // przechowuje bufor przekazanego strumienia
    std::streambuf* strm_puffer = strm.rdbuf();

    // przekierowuje wyjcie do pliku
    strm.rdbuf(file.rdbuf());

    file << "wiersz zapisywany bezporednio do pliku" << std::endl;
    strm  << "wiersz zapisywany do przekierowanego strumienia"
          << std::endl;

    // przywraca poprzedni bufor przekazanego strumienia
    strm.rdbuf(strm_puffer);

}  // zamyka plik i bufor przekierowania

